--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Buenos Aires
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "ba_marketkeep" }
DefineCharacter { name = "ba_shopkeep" }
DefineCharacter { name = "ba_teatrokeep" }
DefineCharacter { name = "ba_avenidakeep" }
DefineCharacter { name = "ba_obeliscokeep" }
DefineCharacter { name = "ba_labkeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "buenosaires",
	available = false,
	ambient = "sfx/metropolitan_loop.ogg",

	layout =
	{
		-- Planes
		SpriteLayer { imagelist=portPlanes, scale=.3, time=20000,hold=6000,bounce=true, random=60,
			path={{-80,35},{100,35},{750,35},{880,35}} },
			
		-- Clouds
		SpriteLayer { image="clouds_03", time=150000, loop=true, htile=true, path={{800,15},{700,15},{100,15},{0,15}}, },
		
		-- Boats
		SpriteLayer { imagelist=portBoats, scale=.25, time=90000,hold=3000,bounce=true,
			path={{-80,85},{100,85},{750,85},{880,85}} },
		
		SpriteLayer { image="ba_skyline", x=0+630/2,y=66+71/2, },
		
		Market { name="ba_market", character="ba_marketkeep", x=104+341/2,y=99+230/2,
			inventory = { almond=true, sugar=true, milk=true, orange=true, lemon=true} },
		Laboratory { name="ba_lab", character="ba_labkeep", x=378+165/2,y=131+235/2, labelx=420,labely=230},
		EmptyBuilding { name="ba_obelisco", character={"ba_obeliscokeep"}, ambient="sfx/other_loop.ogg", x=632+75/2,y=11+210/2, startweek=589 },		-- 1936
		
		EmptyBuilding { name="ba_avenida", character= {"ba_avenidakeep"}, x=474+255/2,y=165+217/2, },

		-- Perspective cars
		SpriteLayer { image="car_07", nearscale=.4,near=377, farscale=.15,far=180,
			path={{425,600},{545,465},{690,211},{730,160}} },
		SpriteLayer { image="car_12", nearscale=.4,near=377, farscale=.15,far=180,
			path={{721,145},{680,209},{500,459},{375,631}} },

		SpriteLayer { image="ba_trees1", x=629+100/2,y=262+115/2, },

		Shop { name="ba_shop", character="ba_shopkeep", x=664+136/2,y=16+393/2, },
		SpriteLayer { image="ba_trees2", x=724+76/2,y=326+95/2, },
		
		-- Diagonal cars
		SpriteLayer { image="car_11", nearscale=.4,near=377, farscale=.13,far=180,
			path={{-75,221},{55,267},{229,336},{473,403},{740,454},{547,509},{200,634},},},

		EmptyBuilding { name="ba_teatro", character={"ba_teatrokeep"}, ambient="sfx/other_loop.ogg", x=0+241/2,y=165+209/2, },
		SpriteLayer { image="ba_trees4", x=0+342/2,y=247+158/2, },
		
		-- Horizontal cars
		SpriteLayer { imagelist=portCars, scale=.5,
			path={{-83,395},{551,376},{492,440},{875,431},}, },
		
	}
}
